import delimited "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/20160718_mve.csv", encoding(ISO-8859-1)clear

gen newdate = date(date, "MDY")
gen quarter = quarter(newdate)
gen month = month(newdate)
gen year = year(newdate)
gen day = day(newdate)

tostring year, gen(year_string)
tostring quarter, gen(quarter_string)
gen year_quarter_string = year_string + quarter_string

gen cusip_short = substr(cusip, 1, 8)
drop cusip
rename cusip_short cusip 

gen mve = prc*shrout
gen mve_units = mve*1000
drop mve
rename mve_units mve

by cusip, sort: gen output_indicator = _n 
br cusip if output_indicator == 1 


save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/mve.dta", replace


import delimited "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/20160718_assets.csv", encoding(ISO-8859-1)clear


gen newdate = date(datadate, "MDY")
gen quarter = quarter(newdate)
gen month = month(newdate)
gen year = year(newdate)
gen day = day(newdate)

gen cusip_short = substr(cusip, 1, 8)
drop cusip
rename cusip_short cusip 

tostring year, gen(year_string)
tostring quarter, gen(quarter_string)
gen year_quarter_string = year_string + quarter_string

by cusip, sort: gen output_indicator = _n 
br cusip if output_indicator == 1 

gen atq_units = atq*1000000
drop atq 
rename atq_units atq

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/assets.dta", replace

merge 1:m cusip year_quarter_string using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/mve.dta"

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/assets_mve_merge.dta", replace

clear
use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/assets_mve_merge.dta"
gen mve_assets_ratio = mve/atq

*** want to do for pre-crisis, crisis, post-crisis 
gen crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2006 
replace crisis = 1 if (year >= 2007 & year < 2010) | (year == 2010 & month == 1) 
replace crisis = 2 if (year >= 2010) | (year == 2010 & month > 1) 
replace crisis = 3 if year == 2015 & month == 12 & day == 31

gen big6 = 0 
replace big6 = 1 if permno == 86868 | permno == 47896 | permno == 69032 | permno == 59408 | permno == 38703 | permno == 70519

*** now display for all banks 
drop output_indicator 
drop if _merge != 3
by crisis cusip, sort: egen mean_mve_ratio_crisis = mean(mve_assets_ratio)
by crisis cusip, sort: gen output_indicator = _n 
br tic cusip conm mve_assets_ratio crisis big6 if big6 == 1 & output_indicator == 1 
br tic cusip conm mve_assets_ratio crisis big6 if big6 == 0 & output_indicator == 1 

*** now by quintile
*** only want this for the non-big 6, so drop big6 here
drop if big6 == 1 
by crisis cusip, sort: egen markcap_crisis = mean(mve)
egen quant_markcap = xtile(markcap_crisis), n(5) by(crisis) 
by crisis quant_markcap, sort: egen mve_ratio_crisis_quant = mean(mve_assets_ratio)

drop output_indicator 
drop if crisis == . 
drop if quant_markcap == . 
by crisis quant_markcap, sort: gen output_indicator = _n 
br crisis quant_markcap markcap_crisis mve_ratio_crisis_quant if output_indicator == 1
